<?php
// phpcs:disable Yoast.NamingConventions.NamespaceName.TooLong -- Needed in the folder structure.
namespace Yoast\WP\SEO\Schema_Aggregator\Infrastructure\Elements_Context_Map;

/**
 * Provides the default elements-context map.
 *
 * @codeCoverageIgnore  -- No logic to test.
 */
class Default_Elements_Context_Map {

	/**
	 * The elements-context map.
	 *
	 * @var array <string, array<string>>
	 */
	private static $map = [
		'action'       => [
			'Action',
			'AcceptAction',
			'AchieveAction',
			'ActivateAction',
			'AddAction',
			'AgreeAction',
			'AllocateAction',
			'AppendAction',
			'ApplyAction',
			'ArriveAction',
			'AskAction',
			'AssessAction',
			'AssignAction',
			'AuthorizeAction',
			'BefriendAction',
			'BookmarkAction',
			'BorrowAction',
			'BuyAction',
			'CancelAction',
			'CheckAction',
			'CheckInAction',
			'CheckOutAction',
			'ChooseAction',
			'ClaimAction',
			'CommentAction',
			'CommunicateAction',
			'ConfirmAction',
			'ConsumeAction',
			'ControlAction',
			'CookAction',
			'CreateAction',
			'DeactivateAction',
			'DeleteAction',
			'DepartAction',
			'DisagreeAction',
			'DiscoverAction',
			'DislikeAction',
			'DonateAction',
			'DownloadAction',
			'DrawAction',
			'DrinkAction',
			'EatAction',
			'EditAction',
			'EndorseAction',
			'ExerciseAction',
			'FilmAction',
			'FindAction',
			'FollowAction',
			'GiveAction',
			'IgnoreAction',
			'InformAction',
			'InsertAction',
			'InstallAction',
			'InteractAction',
			'InviteAction',
			'JoinAction',
			'LeaveAction',
			'LendAction',
			'LikeAction',
			'ListenAction',
			'LoseAction',
			'MarryAction',
			'MoneyTransfer',
			'MoveAction',
			'OrderAction',
			'OrganizeAction',
			'PaintAction',
			'PayAction',
			'PerformAction',
			'PhotographAction',
			'PlanAction',
			'PlayAction',
			'PreOrderAction',
			'PrependAction',
			'QuoteAction',
			'ReactAction',
			'ReadAction',
			'ReceiveAction',
			'RegisterAction',
			'RejectAction',
			'RentAction',
			'ReplaceAction',
			'ReplyAction',
			'ReportAction',
			'ReserveAction',
			'ResumeAction',
			'ReturnAction',
			'ReviewAction',
			'RsvpAction',
			'ScheduleAction',
			'SearchAction',
			'SeekToAction',
			'SellAction',
			'SendAction',
			'ShareAction',
			'SubscribeAction',
			'SuspendAction',
			'TakeAction',
			'TieAction',
			'TipAction',
			'TrackAction',
			'TradeAction',
			'TransferAction',
			'TravelAction',
			'UnRegisterAction',
			'UpdateAction',
			'UseAction',
			'ViewAction',
			'VoteAction',
			'WantAction',
			'WatchAction',
			'WearAction',
			'WinAction',
			'WriteAction',
		],
		'commerce'     => [
			'Product',
			'Car',
			'Drug',
			'DietarySupplement',
			'IndividualProduct',
			'Motorcycle',
			'ProductGroup',
			'ProductModel',
			'SomeProducts',
			'Vehicle',
			'BusOrCoach',
			'MotorizedBicycle',
			'Offer',
			'AggregateOffer',
			'Demand',
			'Order',
			'OrderItem',
			'Invoice',
			'PriceSpecification',
			'CompoundPriceSpecification',
			'DeliveryChargeSpecification',
			'PaymentChargeSpecification',
			'UnitPriceSpecification',
			'ShippingConditions',
			'ShippingDeliveryTime',
			'ShippingRateSettings',
			'ShippingService',
			'MerchantReturnPolicy',
			'MerchantReturnPolicySeasonalOverride',
			'OfferShippingDetails',
			'OfferCatalog',
			'ParcelDelivery',
			'FinancialProduct',
			'BankAccount',
			'CurrencyConversionService',
			'DepositAccount',
			'InvestmentFund',
			'InvestmentOrDeposit',
			'LoanOrCredit',
			'MortgageLoan',
			'PaymentCard',
			'CreditCard',
			'PaymentService',
		],
		'content'      => [
			'CreativeWork',
			'AmpStory',
			'AnalysisNewsArticle',
			'Answer',
			'ArchiveComponent',
			'Article',
			'AskPublicNewsArticle',
			'Atlas',
			'Audiobook',
			'BackgroundNewsArticle',
			'Blog',
			'BlogPosting',
			'Book',
			'BookSeries',
			'Certification',
			'Chapter',
			'Claim',
			'Clip',
			'Code',
			'Collection',
			'ComicCoverArt',
			'ComicIssue',
			'ComicSeries',
			'ComicStory',
			'Comment',
			'Conversation',
			'CorrectionComment',
			'Course',
			'CoverArt',
			'CreativeWorkSeason',
			'CreativeWorkSeries',
			'CriticReview',
			'DataCatalog',
			'DataDownload',
			'Dataset',
			'DefinedTermSet',
			'Diet',
			'DigitalDocument',
			'DiscussionForumPosting',
			'Drawing',
			'EducationalOccupationalCredential',
			'EmailMessage',
			'Episode',
			'ExercisePlan',
			'FAQPage',
			'Game',
			'Guide',
			'HowTo',
			'HowToDirection',
			'HowToSection',
			'HowToStep',
			'HowToTip',
			'HyperToc',
			'HyperTocEntry',
			'ImageGallery',
			'Legislation',
			'LegislationObject',
			'LiveBlogPosting',
			'Manuscript',
			'Map',
			'MathSolver',
			'MediaGallery',
			'MediaObject',
			'MediaReview',
			'MediaReviewItem',
			'Menu',
			'MenuSection',
			'Message',
			'Movie',
			'MovieClip',
			'MovieSeries',
			'MusicAlbum',
			'MusicComposition',
			'MusicPlaylist',
			'MusicRecording',
			'MusicRelease',
			'MusicVideoObject',
			'NewsArticle',
			'Newspaper',
			'NoteDigitalDocument',
			'OpinionNewsArticle',
			'Painting',
			'Periodical',
			'Photograph',
			'Play',
			'Poster',
			'PresentationDigitalDocument',
			'ProductCollection',
			'PublicationIssue',
			'PublicationVolume',
			'Question',
			'Quiz',
			'Quotation',
			'RadioClip',
			'RadioEpisode',
			'RadioSeason',
			'RadioSeries',
			'Recipe',
			'Recommendation',
			'Report',
			'ReportageNewsArticle',
			'Review',
			'ReviewNewsArticle',
			'SatiricalArticle',
			'ScholarlyArticle',
			'Sculpture',
			'Season',
			'SheetMusic',
			'ShortStory',
			'SocialMediaPosting',
			'SoftwareApplication',
			'SoftwareSourceCode',
			'SpecialAnnouncement',
			'SpreadsheetDigitalDocument',
			'Statement',
			'TechArticle',
			'TextDigitalDocument',
			'Thesis',
			'TVClip',
			'TVEpisode',
			'TVSeason',
			'TVSeries',
			'UserBlocks',
			'UserCheckins',
			'UserComments',
			'UserDownloads',
			'UserInteraction',
			'UserLikes',
			'UserPageVisits',
			'UserPlays',
			'UserPlusOnes',
			'UserTweets',
			'VideoClip',
			'VideoGallery',
			'VideoGame',
			'VideoGameClip',
			'VideoGameSeries',
			'VideoObject',
			'VideoObjectSnapshot',
			'VisualArtwork',
			'WebContent',
			'3DModel',
			'AudioObject',
			'AudioObjectSnapshot',
			'ImageObject',
			'ImageObjectSnapshot',
			'JobPosting',
			'HowToItem',
			'HowToSupply',
			'HowToTool',
			'MenuItem',
			'Trip',
			'BoatTrip',
			'BusTrip',
			'Flight',
			'TouristTrip',
			'TrainTrip',
		],
		'data'         => [
			'Intangible',
			'ActionAccessSpecification',
			'AlignmentObject',
			'Audience',
			'BedDetails',
			'Brand',
			'BroadcastChannel',
			'BroadcastFrequencySpecification',
			'ComputerLanguage',
			'DataFeedItem',
			'DefinedTerm',
			'CategoryCode',
			'DefinedRegion',
			'DigitalDocumentPermission',
			'EnergyConsumptionDetails',
			'EntryPoint',
			'FinancialIncentive',
			'FloorPlan',
			'GameServer',
			'GeospatialGeometry',
			'Grant',
			'MonetaryGrant',
			'HealthInsurancePlan',
			'HealthPlanCostSharingSpecification',
			'HealthPlanFormulary',
			'HealthPlanNetwork',
			'Language',
			'MediaSubscription',
			'MemberProgram',
			'Observation',
			'Occupation',
			'OccupationalExperienceRequirements',
			'Permit',
			'GovernmentPermit',
			'ProgramMembership',
			'PropertyValueSpecification',
			'Quantity',
			'Distance',
			'Duration',
			'Energy',
			'Mass',
			'Rating',
			'AggregateRating',
			'EndorsementRating',
			'EmployerAggregateRating',
			'Reservation',
			'BoatReservation',
			'BusReservation',
			'EventReservation',
			'FlightReservation',
			'FoodEstablishmentReservation',
			'LodgingReservation',
			'RentalCarReservation',
			'ReservationPackage',
			'TaxiReservation',
			'TrainReservation',
			'Role',
			'LinkRole',
			'OrganizationRole',
			'EmployeeRole',
			'PerformanceRole',
			'Schedule',
			'Seat',
			'Service',
			'BroadcastService',
			'CableOrSatelliteService',
			'FoodService',
			'GovernmentService',
			'TaxiService',
			'WebAPI',
			'ServiceChannel',
			'SpeakableSpecification',
			'StatisticalPopulation',
			'StructuredValue',
			'CDCPMDRecord',
			'ContactPoint',
			'PostalAddress',
			'DatedMoneySpecification',
			'DeliveryTimeSettings',
			'EngineSpecification',
			'ExchangeRateSpecification',
			'GeoCircle',
			'GeoCoordinates',
			'GeoShape',
			'InteractionCounter',
			'MonetaryAmount',
			'MonetaryAmountDistribution',
			'NutritionInformation',
			'OpeningHoursSpecification',
			'OwnershipInfo',
			'PostalCodeRangeSpecification',
			'PropertyValue',
			'LocationFeatureSpecification',
			'QuantitativeValue',
			'QuantitativeValueDistribution',
			'RepaymentSpecification',
			'ServicePeriod',
			'TypeAndQuantityNode',
			'WarrantyPromise',
			'Ticket',
			'VirtualLocation',
			'DataType',
			'Boolean',
			'False',
			'True',
			'Date',
			'DateTime',
			'Number',
			'Float',
			'Integer',
			'Text',
			'CssSelectorType',
			'PronounceableText',
			'URL',
			'XPathType',
			'Time',
		],
		'entity'       => [
			'Thing',
			'Person',
			'Patient',
			'Organization',
			'Airline',
			'Consortium',
			'Cooperative',
			'Corporation',
			'EducationalOrganization',
			'CollegeOrUniversity',
			'ElementarySchool',
			'HighSchool',
			'MiddleSchool',
			'Preschool',
			'School',
			'FundingScheme',
			'GovernmentOrganization',
			'LibrarySystem',
			'LocalBusiness',
			'MedicalOrganization',
			'DiagnosticLab',
			'Hospital',
			'MedicalClinic',
			'Pharmacy',
			'Physician',
			'VeterinaryCare',
			'MemberProgramTier',
			'NGO',
			'NewsMediaOrganization',
			'OnlineBusiness',
			'OnlineStore',
			'PerformingGroup',
			'DanceGroup',
			'MusicGroup',
			'TheaterGroup',
			'PoliticalParty',
			'Project',
			'FundingAgency',
			'ResearchProject',
			'ResearchOrganization',
			'SearchRescueOrganization',
			'SportsOrganization',
			'SportsTeam',
			'WorkersUnion',
			'AccountingService',
			'AnimalShelter',
			'ArchiveOrganization',
			'AutoBodyShop',
			'AutoDealer',
			'AutoPartsStore',
			'AutoRental',
			'AutoRepair',
			'AutoWash',
			'AutomatedTeller',
			'AutomotiveBusiness',
			'Bakery',
			'BankOrCreditUnion',
			'BarOrPub',
			'BeautySalon',
			'BedAndBreakfast',
			'BikeStore',
			'BookStore',
			'BowlingAlley',
			'Brewery',
			'CafeOrCoffeeShop',
			'Campground',
			'Casino',
			'ChildCare',
			'ClothingStore',
			'ComputerStore',
			'ConvenienceStore',
			'DaySpa',
			'Dentist',
			'DepartmentStore',
			'DistilleryOrganization',
			'Distillery',
			'DryCleaningOrLaundry',
			'ElectronicsStore',
			'EmploymentAgency',
			'EntertainmentBusiness',
			'AdultEntertainment',
			'AmusementPark',
			'ArtGallery',
			'ComedyClub',
			'MovieTheater',
			'NightClub',
			'ExerciseGym',
			'FinancialService',
			'Florist',
			'FoodEstablishment',
			'FurnitureStore',
			'GardenStore',
			'GasStation',
			'GeneralContractor',
			'GolfCourse',
			'GovernmentOffice',
			'PostOffice',
			'GroceryStore',
			'HairSalon',
			'HardwareStore',
			'HealthAndBeautyBusiness',
			'HealthClub',
			'HobbyShop',
			'HomeAndConstructionBusiness',
			'Electrician',
			'HVACBusiness',
			'HousePainter',
			'Locksmith',
			'MovingCompany',
			'Plumber',
			'RoofingContractor',
			'HomeGoodsStore',
			'Hostel',
			'Hotel',
			'IceCreamShop',
			'InsuranceAgency',
			'InternetCafe',
			'JewelryStore',
			'LegalService',
			'Attorney',
			'Notary',
			'Library',
			'LiquorStore',
			'LodgingBusiness',
			'MedicalBusiness',
			'MensClothingStore',
			'MobilePhoneStore',
			'Motel',
			'MotorcycleDealer',
			'MotorcycleRepair',
			'MovieRentalStore',
			'MusicStore',
			'NailSalon',
			'OfficeEquipmentStore',
			'Optician',
			'OutletStore',
			'PawnShop',
			'PetStore',
			'ProfessionalService',
			'RadioStation',
			'RealEstateAgent',
			'RecyclingCenter',
			'Resort',
			'Restaurant',
			'FastFoodRestaurant',
			'SelfStorage',
			'ShoeStore',
			'ShoppingCenter',
			'SkiResort',
			'SportingGoodsStore',
			'SportsActivityLocation',
			'StadiumOrArena',
			'Store',
			'TattooParlor',
			'TelevisionStation',
			'TennisComplex',
			'TireShop',
			'TouristInformationCenter',
			'ToyStore',
			'TravelAgency',
			'WholesaleStore',
			'Winery',
			'Place',
			'Accommodation',
			'Apartment',
			'CampingPitch',
			'House',
			'SingleFamilyResidence',
			'Room',
			'HotelRoom',
			'MeetingRoom',
			'Suite',
			'AdministrativeArea',
			'City',
			'Country',
			'SchoolDistrict',
			'State',
			'CivicStructure',
			'Airport',
			'Aquarium',
			'Beach',
			'BoatTerminal',
			'Bridge',
			'BusStation',
			'BusStop',
			'Cemetery',
			'Crematorium',
			'EventVenue',
			'FireStation',
			'GovernmentBuilding',
			'CityHall',
			'Courthouse',
			'DefenceEstablishment',
			'Embassy',
			'LegislativeBuilding',
			'Museum',
			'MusicVenue',
			'Park',
			'ParkingFacility',
			'PerformingArtsTheater',
			'PlaceOfWorship',
			'BuddhistTemple',
			'Church',
			'CatholicChurch',
			'HinduTemple',
			'Mosque',
			'Synagogue',
			'Playground',
			'PoliceStation',
			'PublicToilet',
			'RVPark',
			'SubwayStation',
			'TaxiStand',
			'TrainStation',
			'Zoo',
			'Landform',
			'BodyOfWater',
			'Canal',
			'LakeBodyOfWater',
			'OceanBodyOfWater',
			'Pond',
			'Reservoir',
			'RiverBodyOfWater',
			'SeaBodyOfWater',
			'Waterfall',
			'Continent',
			'Mountain',
			'Volcano',
			'LandmarksOrHistoricalBuildings',
			'Residence',
			'ApartmentComplex',
			'GatedResidenceCommunity',
			'TouristAttraction',
			'TouristDestination',
			'Taxon',
		],
		'enumeration'  => [
			'RespiratoryTherapy',
			'Enumeration',
			'ActionStatusType',
			'ActiveActionStatus',
			'CompletedActionStatus',
			'FailedActionStatus',
			'PotentialActionStatus',
			'AdultOrientedEnumeration',
			'AlcoholConsideration',
			'DangerousGoodConsideration',
			'HealthcareConsideration',
			'NarcoticConsideration',
			'ReducedRelevanceForChildrenConsideration',
			'SexualContentConsideration',
			'TobaccoNicotineConsideration',
			'UnclassifiedAdultConsideration',
			'ViolenceConsideration',
			'WeaponConsideration',
			'BoardingPolicyType',
			'GroupBoardingPolicy',
			'ZoneBoardingPolicy',
			'BodyMeasurementTypeEnumeration',
			'BodyMeasurementArm',
			'BodyMeasurementBust',
			'BodyMeasurementChest',
			'BodyMeasurementFoot',
			'BodyMeasurementHand',
			'BodyMeasurementHead',
			'BodyMeasurementHeight',
			'BodyMeasurementHips',
			'BodyMeasurementInsideLeg',
			'BodyMeasurementNeck',
			'BodyMeasurementUnderbust',
			'BodyMeasurementWaist',
			'BodyMeasurementWeight',
			'BookFormatType',
			'AudiobookFormat',
			'EBook',
			'GraphicNovel',
			'Hardcover',
			'Paperback',
			'BusinessEntityType',
			'BusinessFunction',
			'CarUsageType',
			'ContactPointOption',
			'HearingImpairedSupported',
			'TollFree',
			'DayOfWeek',
			'Friday',
			'Monday',
			'PublicHolidays',
			'Saturday',
			'Sunday',
			'Thursday',
			'Tuesday',
			'Wednesday',
			'DeliveryMethod',
			'LockerDelivery',
			'OnSitePickup',
			'ParcelService',
			'DigitalDocumentPermissionType',
			'CommentPermission',
			'ReadPermission',
			'WritePermission',
			'DigitalPlatformEnumeration',
			'AndroidPlatform',
			'DesktopWebPlatform',
			'GenericWebPlatform',
			'IOSPlatform',
			'MobileWebPlatform',
			'DigitalSourceType',
			'AlgorithmicMediaDigitalSource',
			'AlgorithmicallyEnhancedDigitalSource',
			'CompositeCaptureDigitalSource',
			'CompositeDigitalSource',
			'CompositeSyntheticDigitalSource',
			'CompositeWithTrainedAlgorithmicMediaDigitalSource',
			'DataDrivenMediaDigitalSource',
			'DigitalArtDigitalSource',
			'DigitalCaptureDigitalSource',
			'MinorHumanEditsDigitalSource',
			'MultiFrameComputationalCaptureDigitalSource',
			'NegativeFilmDigitalSource',
			'PositiveFilmDigitalSource',
			'PrintDigitalSource',
			'ScreenCaptureDigitalSource',
			'TrainedAlgorithmicMediaDigitalSource',
			'VirtualRecordingDigitalSource',
			'DriveWheelConfigurationValue',
			'AllWheelDriveConfiguration',
			'FourWheelDriveConfiguration',
			'FrontWheelDriveConfiguration',
			'RearWheelDriveConfiguration',
			'DrugCostCategory',
			'ReimbursementCap',
			'Retail',
			'Wholesale',
			'DrugPregnancyCategory',
			'FDAcategoryA',
			'FDAcategoryB',
			'FDAcategoryC',
			'FDAcategoryD',
			'FDAcategoryX',
			'FDAnotEvaluated',
			'DrugPrescriptionStatus',
			'OTC',
			'PrescriptionOnly',
			'EUEnergyEfficiencyEnumeration',
			'EUEnergyEfficiencyCategoryA',
			'EUEnergyEfficiencyCategoryA1Plus',
			'EUEnergyEfficiencyCategoryA2Plus',
			'EUEnergyEfficiencyCategoryA3Plus',
			'EUEnergyEfficiencyCategoryB',
			'EUEnergyEfficiencyCategoryC',
			'EUEnergyEfficiencyCategoryD',
			'EUEnergyEfficiencyCategoryE',
			'EUEnergyEfficiencyCategoryF',
			'EUEnergyEfficiencyCategoryG',
			'EnergyStarEnergyEfficiencyEnumeration',
			'EventAttendanceModeEnumeration',
			'MixedEventAttendanceMode',
			'OfflineEventAttendanceMode',
			'OnlineEventAttendanceMode',
			'EventStatusType',
			'EventCancelled',
			'EventMovedOnline',
			'EventPostponed',
			'EventRescheduled',
			'EventScheduled',
			'FulfillmentTypeEnumeration',
			'FulfillmentTypeDelivery',
			'FulfillmentTypePickup',
			'GameAvailabilityEnumeration',
			'DemoGameAvailability',
			'FullGameAvailability',
			'GamePlayMode',
			'CoOp',
			'MultiPlayer',
			'SinglePlayer',
			'GameServerStatus',
			'OfflinePermanently',
			'OfflineTemporarily',
			'Online',
			'OnlineFull',
			'GenderType',
			'Female',
			'Male',
			'GovernmentBenefitsType',
			'BasicIncome',
			'BusinessSupport',
			'DisabilitySupport',
			'HealthCare',
			'OneTimePayments',
			'PaidLeave',
			'ParentalSupport',
			'UnemploymentSupport',
			'HealthAspectEnumeration',
			'AllergiesHealthAspect',
			'BenefitsHealthAspect',
			'CausesHealthAspect',
			'ContagiousnessHealthAspect',
			'EffectivenessHealthAspect',
			'GettingAccessHealthAspect',
			'HowItWorksHealthAspect',
			'HowOrWhereHealthAspect',
			'IngredientsHealthAspect',
			'LivingWithHealthAspect',
			'MayTreatHealthAspect',
			'MisconceptionsHealthAspect',
			'OverviewHealthAspect',
			'PatientExperienceHealthAspect',
			'PregnancyHealthAspect',
			'PreventionHealthAspect',
			'PrognosisHealthAspect',
			'RelatedTopicsHealthAspect',
			'RisksOrComplicationsHealthAspect',
			'SafetyHealthAspect',
			'ScreeningHealthAspect',
			'SeeDoctorHealthAspect',
			'SelfCareHealthAspect',
			'SideEffectsHealthAspect',
			'StagesHealthAspect',
			'SymptomsHealthAspect',
			'TreatmentsHealthAspect',
			'TypesHealthAspect',
			'UsageOrScheduleHealthAspect',
			'IncentiveEligibility',
			'IncentiveStatus',
			'IncentiveType',
			'ItemAvailability',
			'BackOrder',
			'Discontinued',
			'InStock',
			'InStoreOnly',
			'LimitedAvailability',
			'MadeToOrder',
			'OnlineOnly',
			'OutOfStock',
			'PreOrder',
			'PreSale',
			'Reserved',
			'SoldOut',
			'ItemListOrderType',
			'ItemListOrderAscending',
			'ItemListOrderDescending',
			'ItemListUnordered',
			'LegalForceStatus',
			'InForce',
			'NotInForce',
			'PartiallyInForce',
			'LegalValueLevel',
			'AuthoritativeLegalValue',
			'DefinitiveLegalValue',
			'OfficialLegalValue',
			'UnofficialLegalValue',
			'MapCategoryType',
			'ParkingMap',
			'SeatingMap',
			'TransitMap',
			'VenueMap',
			'MeasurementMethodEnum',
			'ExhaustEmissionsMeasurementMethod',
			'MeasurementTypeEnumeration',
			'WearableMeasurementBack',
			'WearableMeasurementChestOrBust',
			'WearableMeasurementCollar',
			'WearableMeasurementCup',
			'WearableMeasurementHeight',
			'WearableMeasurementHips',
			'WearableMeasurementInseam',
			'WearableMeasurementLength',
			'WearableMeasurementOutsideLeg',
			'WearableMeasurementSleeve',
			'WearableMeasurementWaist',
			'WearableMeasurementWidth',
			'MediaManipulationRatingEnumeration',
			'DecontextualizedContent',
			'EditedOrCroppedContent',
			'OriginalMediaContent',
			'SatireOrParodyContent',
			'StagedContent',
			'TransformedContent',
			'MedicalAudienceType',
			'Clinician',
			'MedicalResearcher',
			'MedicalDevicePurpose',
			'Diagnostic',
			'Therapeutic',
			'MedicalEnumeration',
			'MedicalEvidenceLevel',
			'EvidenceLevelA',
			'EvidenceLevelB',
			'EvidenceLevelC',
			'MedicalImagingTechnique',
			'CT',
			'MRI',
			'PET',
			'Radiography',
			'Ultrasound',
			'XRay',
			'MedicalObservationalStudyDesign',
			'CaseSeries',
			'CohortStudy',
			'CrossSectional',
			'Longitudinal',
			'Observational',
			'Registry',
			'MedicalProcedureType',
			'NoninvasiveProcedure',
			'PercutaneousProcedure',
			'MedicalSpecialty',
			'Anesthesia',
			'Cardiovascular',
			'CommunityHealth',
			'Dentistry',
			'Dermatologic',
			'Dermatology',
			'DietNutrition',
			'Emergency',
			'Endocrine',
			'Gastroenterologic',
			'Genetic',
			'Geriatric',
			'Gynecologic',
			'Hematologic',
			'Infectious',
			'LaboratoryScience',
			'Midwifery',
			'Musculoskeletal',
			'Neurologic',
			'Nursing',
			'Obstetric',
			'Oncologic',
			'Optometric',
			'Otolaryngologic',
			'Pathology',
			'Pediatric',
			'PharmacySpecialty',
			'Physiotherapy',
			'PlasticSurgery',
			'Podiatric',
			'PrimaryCare',
			'Psychiatric',
			'PublicHealth',
			'Pulmonary',
			'Renal',
			'Rheumatologic',
			'SpeechPathology',
			'Surgical',
			'Toxicologic',
			'Urologic',
			'MedicalStudyStatus',
			'ActiveNotRecruiting',
			'Completed',
			'EnrollingByInvitation',
			'NotYetRecruiting',
			'Recruiting',
			'ResultsAvailable',
			'ResultsNotAvailable',
			'Suspended',
			'Terminated',
			'Withdrawn',
			'MedicalTrialDesign',
			'DoubleBlindedTrial',
			'InternationalTrial',
			'MultiCenterTrial',
			'OpenTrial',
			'PlaceboControlledTrial',
			'RandomizedTrial',
			'SingleBlindedTrial',
			'SingleCenterTrial',
			'TripleBlindedTrial',
			'MedicineSystem',
			'Ayurvedic',
			'Chiropractic',
			'Homeopathic',
			'Osteopathic',
			'TraditionalChinese',
			'WesternConventional',
			'MerchantReturnEnumeration',
			'MerchantReturnFiniteReturnWindow',
			'MerchantReturnNotPermitted',
			'MerchantReturnUnlimitedWindow',
			'MerchantReturnUnspecified',
			'MusicAlbumProductionType',
			'CompilationAlbum',
			'DJMixAlbum',
			'DemoAlbum',
			'LiveAlbum',
			'MixtapeAlbum',
			'RemixAlbum',
			'SoundtrackAlbum',
			'SpokenWordAlbum',
			'StudioAlbum',
			'MusicAlbumReleaseType',
			'AlbumRelease',
			'BroadcastRelease',
			'EPRelease',
			'SingleRelease',
			'MusicReleaseFormatType',
			'CDFormat',
			'CassetteFormat',
			'DVDFormat',
			'DigitalAudioTapeFormat',
			'DigitalFormat',
			'LaserDiscFormat',
			'VinylFormat',
			'NLNonprofitType',
			'NonprofitANBI',
			'NonprofitSBBI',
			'NonprofitType',
			'OfferItemCondition',
			'DamagedCondition',
			'NewCondition',
			'RefurbishedCondition',
			'UsedCondition',
			'OrderStatus',
			'OrderCancelled',
			'OrderDelivered',
			'OrderInTransit',
			'OrderPaymentDue',
			'OrderPickupAvailable',
			'OrderProblem',
			'OrderProcessing',
			'OrderReturned',
			'PaymentMethod',
			'ByBankTransferInAdvance',
			'ByInvoice',
			'COD',
			'Cash',
			'CheckInAdvance',
			'DirectDebit',
			'InStorePrepay',
			'PhoneCarrierPayment',
			'PaymentStatusType',
			'PaymentAutomaticallyApplied',
			'PaymentComplete',
			'PaymentDeclined',
			'PaymentDue',
			'PaymentPastDue',
			'PhysicalActivityCategory',
			'AerobicActivity',
			'AnaerobicActivity',
			'Balance',
			'Flexibility',
			'LeisureTimeActivity',
			'OccupationalActivity',
			'StrengthTraining',
			'PhysicalExamEnumeration',
			'Abdomen',
			'Appearance',
			'CardiovascularExam',
			'Ear',
			'Eye',
			'Genitourinary',
			'Head',
			'Lung',
			'MusculoskeletalExam',
			'Neck',
			'Neuro',
			'Nose',
			'Skin',
			'Throat',
			'PriceComponentTypeEnumeration',
			'ActivationFee',
			'CleaningFee',
			'DistanceFee',
			'Downpayment',
			'Installment',
			'Subscription',
			'PriceTypeEnumeration',
			'InvoicePrice',
			'ListPrice',
			'MSRP',
			'MinimumAdvertisedPrice',
			'RegularPrice',
			'SRP',
			'SalePrice',
			'StrikethroughPrice',
			'QualitativeValue',
			'RefundTypeEnumeration',
			'ExchangeRefund',
			'FullRefund',
			'StoreCreditRefund',
			'ReservationStatusType',
			'ReservationCancelled',
			'ReservationConfirmed',
			'ReservationHold',
			'ReservationPending',
			'RestrictedDiet',
			'DiabeticDiet',
			'GlutenFreeDiet',
			'HalalDiet',
			'HinduDiet',
			'KosherDiet',
			'LowCalorieDiet',
			'LowFatDiet',
			'LowLactoseDiet',
			'LowSaltDiet',
			'VeganDiet',
			'VegetarianDiet',
			'ReturnFeesEnumeration',
			'FreeReturn',
			'OriginalShippingFees',
			'RestockingFees',
			'ReturnFeesCustomerResponsibility',
			'ReturnShippingFees',
			'ReturnLabelSourceEnumeration',
			'ReturnLabelCustomerResponsibility',
			'ReturnLabelDownloadAndPrint',
			'ReturnLabelInBox',
			'ReturnMethodEnumeration',
			'KeepProduct',
			'ReturnAtKiosk',
			'ReturnByMail',
			'ReturnInStore',
			'RsvpResponseType',
			'RsvpResponseMaybe',
			'RsvpResponseNo',
			'RsvpResponseYes',
			'SizeGroupEnumeration',
			'WearableSizeGroupBig',
			'WearableSizeGroupBoys',
			'WearableSizeGroupExtraShort',
			'WearableSizeGroupExtraTall',
			'WearableSizeGroupGirls',
			'WearableSizeGroupHusky',
			'WearableSizeGroupInfants',
			'WearableSizeGroupJuniors',
			'WearableSizeGroupMaternity',
			'WearableSizeGroupMens',
			'WearableSizeGroupMisses',
			'WearableSizeGroupPetite',
			'WearableSizeGroupPlus',
			'WearableSizeGroupRegular',
			'WearableSizeGroupShort',
			'WearableSizeGroupTall',
			'WearableSizeGroupWomens',
			'SizeSpecification',
			'SizeSystemEnumeration',
			'SizeSystemImperial',
			'SizeSystemMetric',
			'WearableSizeSystemAU',
			'WearableSizeSystemBR',
			'WearableSizeSystemCN',
			'WearableSizeSystemContinental',
			'WearableSizeSystemDE',
			'WearableSizeSystemEN13402',
			'WearableSizeSystemEurope',
			'WearableSizeSystemFR',
			'WearableSizeSystemGS1',
			'WearableSizeSystemIT',
			'WearableSizeSystemJP',
			'WearableSizeSystemMX',
			'WearableSizeSystemUK',
			'WearableSizeSystemUS',
			'Specialty',
			'StatusEnumeration',
			'SteeringPositionValue',
			'LeftHandDriving',
			'RightHandDriving',
			'USNonprofitType',
			'Nonprofit501a',
			'Nonprofit501c1',
			'Nonprofit501c10',
			'Nonprofit501c11',
			'Nonprofit501c12',
			'Nonprofit501c13',
			'Nonprofit501c14',
			'Nonprofit501c15',
			'Nonprofit501c16',
			'Nonprofit501c17',
			'Nonprofit501c18',
			'Nonprofit501c19',
			'Nonprofit501c2',
			'Nonprofit501c20',
			'Nonprofit501c21',
			'Nonprofit501c22',
			'Nonprofit501c23',
			'Nonprofit501c24',
			'Nonprofit501c25',
			'Nonprofit501c26',
			'Nonprofit501c27',
			'Nonprofit501c28',
			'Nonprofit501c3',
			'Nonprofit501c4',
			'Nonprofit501c5',
			'Nonprofit501c6',
			'Nonprofit501c7',
			'Nonprofit501c8',
			'Nonprofit501c9',
			'Nonprofit501d',
			'Nonprofit501e',
			'Nonprofit501f',
			'Nonprofit501k',
			'Nonprofit501n',
			'Nonprofit501q',
			'Nonprofit527',
			'WarrantyScope',
		],
		'event'        => [
			'Event',
			'BusinessEvent',
			'ChildrensEvent',
			'ComedyEvent',
			'CourseInstance',
			'DanceEvent',
			'DeliveryEvent',
			'EducationEvent',
			'EventSeries',
			'ExhibitionEvent',
			'Festival',
			'FoodEvent',
			'Hackathon',
			'LiteraryEvent',
			'MusicEvent',
			'OnDemandEvent',
			'PublicationEvent',
			'BroadcastEvent',
			'SaleEvent',
			'ScreeningEvent',
			'SocialEvent',
			'SportsEvent',
			'TheaterEvent',
			'VisualArtsEvent',
		],
		'medical'      => [
			'MedicalEntity',
			'AnatomicalStructure',
			'Artery',
			'Bone',
			'BrainStructure',
			'Joint',
			'Ligament',
			'Muscle',
			'Nerve',
			'Vein',
			'AnatomicalSystem',
			'DrugClass',
			'DrugCost',
			'DrugStrength',
			'DoseSchedule',
			'MaximumDoseSchedule',
			'RecommendedDoseSchedule',
			'ReportedDoseSchedule',
			'LifestyleModification',
			'PhysicalActivity',
			'MedicalCause',
			'MedicalCondition',
			'InfectiousDisease',
			'MedicalSignOrSymptom',
			'MedicalSign',
			'VitalSign',
			'MedicalSymptom',
			'MedicalContraindication',
			'MedicalDevice',
			'MedicalGuideline',
			'MedicalGuidelineContraindication',
			'MedicalGuidelineRecommendation',
			'MedicalIndication',
			'ApprovedIndication',
			'PreventionIndication',
			'TreatmentIndication',
			'MedicalIntangible',
			'DDxElement',
			'MedicalCode',
			'MedicalConditionStage',
			'MedicalProcedure',
			'DiagnosticProcedure',
			'PalliativeProcedure',
			'PhysicalExam',
			'SurgicalProcedure',
			'TherapeuticProcedure',
			'MedicalRiskCalculator',
			'MedicalRiskEstimator',
			'MedicalRiskFactor',
			'MedicalRiskScore',
			'MedicalStudy',
			'MedicalObservationalStudy',
			'MedicalTrial',
			'MedicalTest',
			'BloodTest',
			'ImagingTest',
			'MedicalTestPanel',
			'PathologyTest',
			'MedicalTherapy',
			'OccupationalTherapy',
			'PhysicalTherapy',
			'RadiationTherapy',
			'Substance',
			'SuperficialAnatomy',
		],
		'meta'         => [ 'Class', 'Property' ],
		'website'      => [
			'WebSite',
			'WebPage',
			'WebPageElement',
			'AboutPage',
			'CheckoutPage',
			'CollectionPage',
			'ContactPage',
			'ItemPage',
			'MedicalWebPage',
			'ProfilePage',
			'QAPage',
			'RealEstateListing',
			'SearchResultsPage',
		],
		'website-meta' => [
			'SiteNavigationElement',
			'BreadcrumbList',
			'ItemList',
			'ListItem',
			'WPAdBlock',
			'WPFooter',
			'WPHeader',
			'WPSideBar',
			'Table',
		],
	];

	/**
	 * Get the full map of schema.org types.
	 *
	 * @return array<string,array<string>> The map;
	 */
	public static function get(): array {
		return self::$map;
	}
}
