<?php

$settings_sections = array(
	'dashboard' => array(
		'title'     => esc_html__( 'Dashboard', 'elementskit-lite' ),
		'sub-title' => esc_html__( 'General info', 'elementskit-lite' ),
		'icon'      => 'icon icon-home',
		'svg'       => '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 40 40" style="enable-background:new 0 0 40 40" xml:space="preserve"><style type="text/css">.st0{clip-path:url(#SVGID_2_)}</style><g><defs><rect id="SVGID_1_" width="40" height="40"/></defs><clipPath id="SVGID_2_"><use xlink:href="#SVGID_1_" style="overflow:visible"/></clipPath><g class="st0"><path d="M32.1,40h-6.7c-0.7,0-1.2-0.6-1.2-1.2V27.9c0-0.2-0.2-0.4-0.4-0.4h-7.5c-0.2,0-0.4,0.2-0.4,0.4v10.8
		c0,0.7-0.6,1.2-1.2,1.2H7.9C6.3,40,5,38.7,5,37.1V21.7H2.1c-1.1,0-2.1-0.9-2.1-2.1c0-0.6,0.2-1.1,0.6-1.5L19.1,0.3
		c0.5-0.5,1.2-0.5,1.7,0l18.5,17.7c0.4,0.4,0.6,1,0.6,1.5c0,1.1-0.9,2.1-2.1,2.1H35v15.4C35,38.7,33.7,40,32.1,40z M26.7,37.5h5.4
		c0.2,0,0.4-0.2,0.4-0.4V20.4c0-0.7,0.6-1.2,1.2-1.2h3.1L20,3L3.1,19.2h3.1c0.7,0,1.2,0.6,1.2,1.2v16.7c0,0.2,0.2,0.4,0.4,0.4h5.4
		v-9.6c0-1.6,1.3-2.9,2.9-2.9h7.5c1.6,0,2.9,1.3,2.9,2.9V37.5z"/></g></g></svg>',
		// 'view_path' => 'some path to the view file'
	),
	'widgets' => array(
		'title'     => esc_html__( 'Widgets', 'elementskit-lite' ),
		'sub-title' => esc_html__( 'Enable disable widgets', 'elementskit-lite' ),
		'icon'      => 'icon icon-magic-wand',
		'svg'       => '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 40 40" style="enable-background:new 0 0 40 40" xml:space="preserve"><g><path d="M33.8,21.2H25c-2.1,0-3.8,1.7-3.8,3.8v8.8c0,2.1,1.7,3.8,3.8,3.8h8.8c2.1,0,3.8-1.7,3.8-3.8V25
		C37.5,22.9,35.8,21.2,33.8,21.2z M35,33.8c0,0.7-0.6,1.2-1.2,1.2H25c-0.7,0-1.2-0.6-1.2-1.2V25c0-0.7,0.6-1.2,1.2-1.2h8.8
		c0.7,0,1.2,0.6,1.2,1.2V33.8z"/><path d="M15,2.5H6.2c-2.1,0-3.8,1.7-3.8,3.8V15c0,2.1,1.7,3.8,3.8,3.8H15c2.1,0,3.8-1.7,3.8-3.8V6.2C18.8,4.2,17.1,2.5,15,2.5z
			M16.2,15c0,0.7-0.6,1.2-1.2,1.2H6.2C5.6,16.2,5,15.7,5,15V6.2C5,5.6,5.6,5,6.2,5H15c0.7,0,1.2,0.6,1.2,1.2V15z"/><path d="M22.5,11.2h5.6v6.2c0,0.7,0.6,1.2,1.2,1.2s1.2-0.6,1.2-1.2v-6.2h5.6c0.7,0,1.2-0.6,1.2-1.2s-0.6-1.2-1.2-1.2h-5.6v-5
		c0-0.7-0.6-1.2-1.2-1.2s-1.2,0.6-1.2,1.2v5h-5.6c-0.7,0-1.2,0.6-1.2,1.2S21.8,11.2,22.5,11.2z"/><path d="M15,21.2H6.2c-2.1,0-3.8,1.7-3.8,3.8v8.8c0,2.1,1.7,3.8,3.8,3.8H15c2.1,0,3.8-1.7,3.8-3.8V25C18.8,22.9,17.1,21.2,15,21.2z
			M16.2,33.8c0,0.7-0.6,1.2-1.2,1.2H6.2C5.6,35,5,34.4,5,33.8V25c0-0.7,0.6-1.2,1.2-1.2H15c0.7,0,1.2,0.6,1.2,1.2V33.8z"/></g></svg>',
	),
	'modules' => array(
		'title'     => esc_html__( 'Modules', 'elementskit-lite' ),
		'sub-title' => esc_html__( 'Enable disable modules', 'elementskit-lite' ),
		'icon'      => 'icon icon-settings-2',
		'svg'       => '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 40 40" style="enable-background:new 0 0 40 40" xml:space="preserve"><g><path d="M2.1,7.8h19c0.6,2.6,3,4.4,5.6,4.4s5-1.8,5.6-4.4h5.6c0.7,0,1.3-0.6,1.3-1.3s-0.6-1.3-1.3-1.3h-5.6c-0.6-2.6-3-4.4-5.6-4.4
		s-5,1.8-5.6,4.4h-19c-0.7,0-1.3,0.6-1.3,1.3S1.4,7.8,2.1,7.8z M26.7,3.4c1.7,0,3.1,1.4,3.1,3.1s-1.4,3.1-3.1,3.1
		c-1.7,0-3.1-1.4-3.1-3.1C23.5,4.8,25,3.4,26.7,3.4z"/><path d="M37.9,18.7h-19c-0.6-2.6-3-4.4-5.6-4.4c-2.7,0-5,1.8-5.6,4.4H2.1c-0.7,0-1.3,0.6-1.3,1.3s0.6,1.3,1.3,1.3h5.6
		c0.6,2.6,3,4.4,5.6,4.4s5-1.8,5.6-4.4h19c0.7,0,1.3-0.6,1.3-1.3S38.6,18.7,37.9,18.7z M13.3,23.1c-1.7,0-3.1-1.4-3.1-3.1
		c0-1.7,1.4-3.1,3.1-3.1c1.7,0,3.1,1.4,3.1,3.1C16.5,21.7,15.1,23.1,13.3,23.1z"/><path d="M37.9,32.2h-5.6c-0.6-2.6-3-4.4-5.6-4.4s-5,1.8-5.6,4.4h-19c-0.7,0-1.3,0.6-1.3,1.3s0.6,1.3,1.3,1.3h19
		c0.6,2.6,3,4.4,5.6,4.4s5-1.8,5.6-4.4h5.6c0.7,0,1.3-0.6,1.3-1.3S38.6,32.2,37.9,32.2z M26.7,36.6c-1.7,0-3.1-1.4-3.1-3.1
		c0-1.7,1.4-3.1,3.1-3.1c1.7,0,3.1,1.4,3.1,3.1S28.4,36.6,26.7,36.6z"/></g></svg>',
	),
	'usersettings' => array(
		'title'     => esc_html__( 'User Settings', 'elementskit-lite' ),
		'sub-title' => esc_html__( 'Settings for fb, mailchimp etc', 'elementskit-lite' ),
		'icon'      => 'icon icon-settings1',
		'svg'       => '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 40 40" style="enable-background:new 0 0 40 40" xml:space="preserve"><g><g><path d="M15.2,20c0.6,0,1-0.5,1-1s-0.5-1-1-1c-3.8,0-6.8,3-6.8,6.8c0,3.8,3,6.8,6.8,6.8c3.8,0,6.8-3,6.8-6.8c0-0.6-0.5-1-1-1
		c-0.6,0-1,0.5-1,1c0,2.6-2.1,4.8-4.8,4.8c-2.6,0-4.8-2.1-4.8-4.8C10.4,22.2,12.6,20,15.2,20z"/><path d="M27.9,26.3l-2.1,0.4c-0.4,0.1-0.7,0.4-0.8,0.7c-0.2,0.8-0.6,1.6-1,2.4c-0.2,0.3-0.2,0.8,0,1.1l1.2,1.8
		c0.2,0.2,0.1,0.6-0.1,0.8l-1.3,1.3c-0.2,0.2-0.5,0.2-0.8,0.1l-1.8-1.2c-0.3-0.2-0.8-0.2-1.1,0c-0.8,0.4-1.6,0.8-2.4,1
		c-0.4,0.1-0.7,0.4-0.7,0.8l-0.4,2.1c-0.1,0.3-0.3,0.5-0.6,0.5h-1.8c-0.3,0-0.6-0.2-0.6-0.5l-0.4-2.1c-0.1-0.4-0.4-0.7-0.7-0.8
		c-0.8-0.2-1.6-0.6-2.4-1c-0.3-0.2-0.8-0.2-1.1,0l-1.8,1.2C7.1,35,6.7,35,6.5,34.7l-1.3-1.3C5,33.3,5,32.9,5.2,32.7l1.2-1.8
		c0.2-0.3,0.2-0.8,0-1.1c-0.4-0.8-0.8-1.6-1-2.4c-0.1-0.4-0.4-0.7-0.8-0.7l-2.1-0.4C2.2,26.3,2,26,2,25.7v-1.8
		c0-0.3,0.2-0.6,0.5-0.6l2.1-0.4c0.4-0.1,0.7-0.4,0.8-0.7c0.2-0.8,0.6-1.7,1-2.4c0.2-0.3,0.2-0.8,0-1.1l-1.2-1.8
		C5,16.7,5,16.3,5.3,16.1l1.3-1.3c0.2-0.2,0.5-0.2,0.8-0.1L9.1,16c0.3,0.2,0.8,0.2,1.1,0c0.8-0.4,1.6-0.8,2.4-1
		c0.4-0.1,0.7-0.4,0.7-0.8l0.4-2.1c0.1-0.6-0.3-1.1-0.8-1.2s-1.1,0.3-1.2,0.8l-0.3,1.5c-0.6,0.2-1.1,0.4-1.7,0.7l-1.3-0.9
		c-1.1-0.7-2.5-0.6-3.4,0.3l-1.3,1.3c-0.9,0.9-1,2.3-0.3,3.4l0.9,1.3c-0.3,0.5-0.5,1.1-0.7,1.7l-1.5,0.3C0.9,21.5,0,22.6,0,23.9
		v1.8c0,1.3,0.9,2.4,2.2,2.6l1.5,0.3c0.2,0.6,0.4,1.1,0.7,1.7l-0.9,1.3c-0.7,1.1-0.6,2.5,0.3,3.4l1.3,1.3c0.9,0.9,2.3,1,3.4,0.3
		l1.2-0.9c0.5,0.3,1.1,0.5,1.7,0.7l0.3,1.5c0.2,1.3,1.3,2.2,2.6,2.2h1.8c1.3,0,2.4-0.9,2.6-2.2l0.3-1.5c0.6-0.2,1.1-0.4,1.7-0.7
		l1.3,0.9c1.1,0.7,2.5,0.6,3.4-0.3l1.3-1.3c0.9-0.9,1-2.3,0.3-3.4L26,30.3c0.3-0.5,0.5-1.1,0.7-1.7l1.5-0.3
		c0.6-0.1,0.9-0.6,0.8-1.2C29,26.6,28.4,26.2,27.9,26.3z"/><path d="M38.1,9.2L37,9c-0.1-0.4-0.3-0.8-0.5-1.1L37.2,7c0.6-0.9,0.5-2.2-0.3-3l-1-1c-0.8-0.8-2-0.9-3-0.3l-0.9,0.6
		C31.7,3.3,31.3,3.1,31,3l-0.2-1.1C30.6,0.8,29.6,0,28.5,0h-1.4C26,0,25,0.8,24.8,1.9L24.6,3c-0.4,0.1-0.8,0.3-1.1,0.5l-0.9-0.6
		c-0.9-0.6-2.2-0.5-3,0.3l-1,1c-0.8,0.8-0.9,2-0.3,3L19,7.9c-0.2,0.4-0.3,0.7-0.5,1.1l-1.1,0.2c-1.1,0.2-1.9,1.2-1.9,2.3v1.4
		c0,1.1,0.8,2.1,1.9,2.3l1.1,0.2c0.1,0.4,0.3,0.8,0.5,1.1l-0.6,0.9c-0.6,0.9-0.5,2.2,0.3,3l1,1c0.8,0.8,2,0.9,3,0.3l0.9-0.6
		c0.4,0.2,0.7,0.3,1.1,0.5l0.2,1.1c0.2,1.1,1.2,1.9,2.3,1.9h1.4c1.1,0,2.1-0.8,2.3-1.9l0.2-1.1c0.4-0.1,0.8-0.3,1.1-0.5l0.9,0.6
		c0.9,0.6,2.2,0.5,3-0.3l1-1c0.8-0.8,0.9-2,0.3-3l-0.6-0.9c0.2-0.4,0.3-0.7,0.5-1.1l1.1-0.2C39.2,15,40,14,40,12.9v-1.4
		C40,10.4,39.2,9.4,38.1,9.2z M38,12.9c0,0.1-0.1,0.2-0.2,0.3l-1.7,0.3c-0.4,0.1-0.7,0.4-0.8,0.7c-0.2,0.6-0.4,1.3-0.8,1.8
		c-0.2,0.3-0.2,0.8,0,1.1l1,1.4c0.1,0.1,0.1,0.3,0,0.4l-1,1c-0.1,0.1-0.2,0.1-0.3,0l-1.4-1c-0.3-0.2-0.8-0.2-1.1,0
		c-0.6,0.3-1.2,0.6-1.8,0.8c-0.4,0.1-0.7,0.4-0.7,0.8l-0.3,1.7c0,0.1-0.1,0.2-0.3,0.2h-1.4c-0.1,0-0.2-0.1-0.3-0.2l-0.3-1.7
		c-0.1-0.4-0.4-0.7-0.7-0.8c-0.6-0.2-1.3-0.4-1.8-0.8c-0.3-0.2-0.8-0.2-1.1,0l-1.4,1c-0.1,0.1-0.3,0.1-0.3,0l-1-1
		c-0.1-0.1-0.1-0.2,0-0.4l1-1.4c0.2-0.3,0.2-0.8,0-1.1c-0.3-0.6-0.6-1.2-0.8-1.8c-0.1-0.4-0.4-0.7-0.8-0.7l-1.7-0.3
		c-0.1,0-0.2-0.1-0.2-0.3l0-1.4c0-0.1,0.1-0.2,0.2-0.3l1.7-0.3c0.4-0.1,0.7-0.4,0.8-0.7c0.2-0.6,0.4-1.3,0.8-1.8
		c0.2-0.3,0.2-0.8,0-1.1l-1-1.4c-0.1-0.1-0.1-0.3,0-0.3l1-1c0.1-0.1,0.2-0.1,0.4,0l1.4,1c0.3,0.2,0.8,0.2,1.1,0
		c0.6-0.3,1.2-0.6,1.8-0.8c0.4-0.1,0.7-0.4,0.7-0.8l0.3-1.7C26.8,2.1,27,2,27.1,2h1.4c0.1,0,0.2,0.1,0.3,0.2l0.3,1.7
		c0.1,0.4,0.4,0.7,0.7,0.8c0.6,0.2,1.3,0.4,1.8,0.8c0.3,0.2,0.8,0.2,1.1,0l1.4-1c0.1-0.1,0.3-0.1,0.4,0l1,1c0.1,0.1,0.1,0.2,0,0.3
		l-1,1.4c-0.2,0.3-0.2,0.8,0,1.1c0.3,0.6,0.6,1.2,0.8,1.8c0.1,0.4,0.4,0.7,0.8,0.7l1.7,0.3c0.1,0,0.2,0.1,0.2,0.3V12.9z"/><path d="M27.8,7.3c-2.7,0-4.9,2.2-4.9,4.9c0,2.7,2.2,4.8,4.9,4.9c2.7,0,4.9-2.2,4.9-4.9C32.7,9.5,30.5,7.3,27.8,7.3z M27.8,15
		c-1.6,0-2.8-1.3-2.8-2.8c0-1.6,1.3-2.8,2.8-2.8v0c1.6,0,2.8,1.3,2.8,2.8S29.4,15,27.8,15z"/></g></g></svg>',
	),
);

$settings_sections = apply_filters( 'elementskit/admin/settings_sections/list', $settings_sections );


$onboard_steps = array(
	'step-01' => array(
		'title'     => esc_html__( 'Configuration', 'elementskit-lite' ),
		'sub-title' => esc_html__( 'Configuration info', 'elementskit-lite' ),
		'icon'      => 'icon icon-ekit',
		// 'view_path' => 'some path to the view file'
	),
	'step-02' => array(
		'title'     => esc_html__( 'Sign Up', 'elementskit-lite' ),
		'sub-title' => esc_html__( 'Sign Up info', 'elementskit-lite' ),
		'icon'      => 'icon icon-user',
	),
	'step-03' => array(
		'title'     => esc_html__( 'Website Powerup', 'elementskit-lite' ),
		'sub-title' => esc_html__( 'Website Powerup info', 'elementskit-lite' ),
		'icon'      => 'icon icon-cog',
	),
	'step-04' => array(
		'title'     => esc_html__( 'Tutorial', 'elementskit-lite' ),
		'sub-title' => esc_html__( 'Tutorial info', 'elementskit-lite' ),
		'icon'      => 'icon icon-youtube-1',
	),
	'step-05' => array(
		'title'     => esc_html__( 'Surprise', 'elementskit-lite' ),
		'sub-title' => esc_html__( 'Surprise info', 'elementskit-lite' ),
		'icon'      => 'icon icon-gift1',
	),
	'step-06' => array(
		'title'     => esc_html__( 'Finalizing', 'elementskit-lite' ),
		'sub-title' => esc_html__( 'Finalizing info', 'elementskit-lite' ),
		'icon'      => 'icon icon-smile',
	),
);

$installed_date = strtotime( get_option( 'elementskit-lite_install_date' ) );
if ( ( 3600 * 24 ) < ( time() - $installed_date ) ) {
	unset( $onboard_steps['step-01'] );
}

if ( \ElementsKit_Lite::package_type() != 'free' ) {
	unset( $onboard_steps['step-05'] );
}

$onboard_steps = apply_filters( 'elementskit/admin/onboard_steps/list', $onboard_steps );

/**
 * We are checking the dashboard page on the Elementskit main page or onboard page and then we decide which template to show.
 * We are not saving any request data, just using it for checking.
 */


 // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Checking current page type. The page only can access admin. So nonce verification is not required.
 $step_css_class = isset($_GET['ekit-onboard-steps']) && $_GET['ekit-onboard-steps'] == 'loaded' ? 'ekit-onboard-dashboard' : '';
?>
<div class="ekit-wid-con <?php echo esc_attr( $step_css_class ) ?>">
    <div class="ekit_container">
        <form action="" method="POST" id="ekit-admin-settings-form">
            <?php 
                if( !empty( $step_css_class ) ) {
                    include 'layout-onboard.php'; 
                } else {
                    do_action('elementskit/admin/settings_sections/before');
                    include 'layout-settings.php';
                }
            ?>
        </form>
    </div>
</div>
